const Applet = imports.ui.applet;
const GLib = imports.gi.GLib;
const Lang = imports.lang;
const Mainloop = imports.mainloop;
const PopupMenu = imports.ui.popupMenu;
const Util = imports.misc.util;

function OTCApplet(orientation, panel_height, instance_id) {
    this._init(orientation, panel_height, instance_id);
}

OTCApplet.prototype = {
    __proto__: Applet.TextApplet.prototype,

    _init: function(orientation, panel_height, instance_id) {
        Applet.TextApplet.prototype._init.call(this, orientation, panel_height, instance_id);
        this.set_applet_label(_("000 000"));

        this.menuManager = new PopupMenu.PopupMenuManager(this);
        this.menu = new Applet.AppletPopupMenu(this, orientation);
        this.menuManager.addMenu(this.menu);
        this._contentSection = new PopupMenu.PopupMenuSection();
        this.menu.addMenuItem(this._contentSection);

        this.refresh();
        // loop every 5 minutes (300 seconds)
        this.timeout = Mainloop.timeout_add_seconds(300, Lang.bind(this, this.refresh));
        this.keepUpdating = true;
    },

    refresh: function() {
        var gdate = new Date();
        var ndate = new Date(gdate.getFullYear(), 2, 19);
        var clday = 1000 * 60 * 60 * 24;
        var wktot = 365 / 5;
        if (gdate >= ndate) { // past new year
            var yrotc = gdate.getFullYear() - 2000;
            var dyotc = Math.ceil((gdate - ndate) / clday);
            var dfotc = 365 - dyotc;
            var wkotc = Math.ceil(dyotc / 5);
        } else { // before new year
        var yrotc = gdate.getFullYear() - 2001;
        var dfotc = Math.ceil((ndate - gdate) / clday);
        var dyotc = 365 - dfotc;
        var wkotc = Math.ceil(dyotc / 5);
        }
        var wklef = wktot - wkotc;
        var dyper = Math.floor((dyotc / 365) * 100);
        var wkper = Math.floor((wkotc / 73) * 100);

        this.set_applet_label(_(dyotc + " 0" + yrotc));
        this.set_applet_tooltip(_("Day " + dyotc + " Week " + wkotc + " Year 0" + yrotc));

        this.menu.removeAll();
        var item = new PopupMenu.PopupMenuItem("Day  " + dyotc + "  -" + dfotc + "  " + dyper + "%");
        this.menu.addMenuItem(item);
        item = new PopupMenu.PopupMenuItem("Week  " + wkotc + "  -" + wklef + "");
        this.menu.addMenuItem(item);
        item = new PopupMenu.PopupMenuItem("Year  4,547,742,0" + yrotc + "");
        this.menu.addMenuItem(item);

        return this.keepUpdating;
    },

    on_applet_clicked: function () {
        this.menu.toggle();
    },

    on_applet_removed_from_panel: function() {
    this.keepUpdating = false;
    if (this.timeout) Mainloop.source_remove(this.timeout);
    this.timeout = 0;
  } 
};

function main(metadata, orientation, panel_height, instance_id) {
    return new OTCApplet(orientation, panel_height, instance_id);
}